<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Gallery;

use \UtillzCore\Inc\Src\Listing\Modules\Module;

class Gallery extends Module {

    public function controller() {

        global $ulz_listing;

      if (isset($this->props) && isset($this->props->display)) {
    if ($this->props->display == 'adaptive') {
        $gallery = $ulz_listing->get_gallery([
            'ulz_gallery_large',
            'ulz_gallery_preview'
        ], $this->props->id);
    }
} else{
            $gallery = [];
            $files = Ucore()->jsoning( $this->props->id, $ulz_listing->id );
            foreach( $files as $file ) {
                $file_src = wp_get_attachment_url( $file->id );
                $gallery[] = [
                    'id' => $file->id,
                    'src' => $file_src,
                    'name' => basename( $file_src ),
                ];
            }
        }

        return array_merge( (array) $this->props, [
            'name' => $this->props->name,
            'gallery' => $gallery,
            'gallery_num' => count( $gallery ),
            'strings' => (object) [
                'more_images' => esc_html__( '+%s', 'heilz' )
            ]
        ]);

    }

}
